﻿using System.Web.UI;
using System.Collections.Generic;
namespace Controls
{
    public class SimpleComponent : ScriptControl
    {
        protected override IEnumerable<ScriptDescriptor> GetScriptDescriptors()
        {
            if (ScriptManager.GetCurrent(this.Page).IsInAsyncPostBack)
            {
                ScriptComponentDescriptor scd = new ScriptComponentDescriptor("MyComponent");
                scd.ID = "Partial Postback Component";
                yield return scd;
            }
            else
            {
                ScriptComponentDescriptor scd = new ScriptComponentDescriptor("MyComponent");
                scd.ID = "Non-Partial Postback Component";
                yield return scd;
            }
        }

        protected override IEnumerable<ScriptReference> GetScriptReferences()
        {
            yield return new ScriptReference("Controls.JavaScript.Component.js", "Controls");
        }

        protected override void OnPreRender(System.EventArgs e)
        {
            base.OnPreRender(e);
        }
    }
}
